# Ghid de instalare pe cPanel

## Pași rapizi pentru cPanel

### Metoda 1: Upload folder vendor (CEL MAI SIMPLU) ⭐

1. **Pe computerul tău local:**
   ```bash
   composer install
   ```
   Aceasta va crea folderul `vendor/` cu toate dependențele.

2. **În cPanel:**
   - Intră în **File Manager**
   - Navighează la directorul unde vrei să uploadezi scripturile (de obicei `public_html/` sau un subfolder)
   - Upload toate fișierele:
     - `stripe_test.php`
     - `create_payment.php`
     - `composer.json`
     - **Folderul `vendor/`** (întreg, cu toate subfolderele)

3. **Structura finală pe server:**
   ```
   public_html/
   ├── stripe_test.php
   ├── create_payment.php
   ├── composer.json
   └── vendor/
       ├── autoload.php
       └── stripe/
           └── stripe-php/
   ```

4. **Testează:**
   - Accesează: `https://domeniultau.ro/stripe_test.php`
   - Sau rulează prin SSH: `php stripe_test.php`

---

### Metoda 2: Folosind SSH (dacă ai acces)

1. **Conectează-te prin SSH:**
   ```bash
   ssh username@serverul-tau.ro
   ```

2. **Navighează la directorul proiectului:**
   ```bash
   cd public_html/stripe-test
   ```

3. **Verifică dacă Composer este instalat:**
   ```bash
   composer --version
   ```

4. **Dacă nu este instalat, instalează-l:**
   ```bash
   curl -sS https://getcomposer.org/installer | php
   php composer.phar install
   ```

5. **Dacă Composer este deja instalat:**
   ```bash
   composer install
   ```

---

### Metoda 3: Folosind Terminal cPanel

1. În cPanel, caută secțiunea **Terminal** sau **Advanced → Terminal**
2. Navighează la directorul proiectului:
   ```bash
   cd public_html/stripe-test
   ```
3. Rulează:
   ```bash
   composer install
   ```

---

### Metoda 4: Fără Composer (Download manual Stripe SDK)

Dacă nu poți folosi Composer deloc:

1. **Descarcă Stripe PHP SDK:**
   - Mergi la: https://github.com/stripe/stripe-php/releases
   - Descarcă ultima versiune (ex: `stripe-php-13.0.0.zip`)

2. **Extrage arhiva:**
   - Extrage folderul `lib/` din arhivă

3. **Upload în cPanel:**
   - În File Manager, upload folderul `lib/` în același director cu scripturile

4. **Folosește `stripe_test_simple.php`:**
   - Acest script verifică automat dacă există `lib/` sau `vendor/`
   - Nu necesită Composer

---

## Verificare instalare

După instalare, testează accesând:
- `https://domeniultau.ro/stripe_test.php` (în browser)
- Sau prin SSH: `php stripe_test.php` (în terminal)

Dacă vezi erori despre "vendor/autoload.php", înseamnă că folderul `vendor/` nu a fost uploadat corect sau nu există.

---

## Probleme comune

### Eroare: "Class 'Stripe\Stripe' not found"
**Soluție:** Folderul `vendor/` nu este în locația corectă sau nu a fost uploadat complet.

### Eroare: "Permission denied"
**Soluție:** Verifică permisiunile folderelor (755 pentru foldere, 644 pentru fișiere).

### Composer nu este instalat pe server
**Soluție:** Folosește Metoda 1 (upload manual) sau Metoda 4 (download manual SDK).

---

## Structura recomandată pe cPanel

```
public_html/
├── stripe-test/              (subfolder opțional)
│   ├── stripe_test.php
│   ├── create_payment.php
│   ├── composer.json
│   └── vendor/
│       └── ...
└── index.php                 (fișierul tău principal)
```

SAU direct în `public_html/`:
```
public_html/
├── stripe_test.php
├── create_payment.php
├── composer.json
└── vendor/
    └── ...
```

