<?php
/**
 * Endpoint pentru crearea unui Payment Intent
 * Folosește acest endpoint din frontend pentru a crea un Payment Intent
 */

header('Content-Type: application/json');

// Încarcă Stripe SDK (funcționează cu sau fără Composer)
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
} elseif (file_exists(__DIR__ . '/lib/init.php')) {
    require_once __DIR__ . '/lib/init.php';
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Stripe SDK nu este instalat. Descarcă de la: https://github.com/stripe/stripe-php/releases',
    ]);
    exit;
}

// Cheia secretă Stripe
$secretKey = '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';

\Stripe\Stripe::setApiKey($secretKey);

// Obține datele din request
$input = json_decode(file_get_contents('php://input'), true);
$amount = isset($input['amount']) ? floatval($input['amount']) : 100.00;
$currency = isset($input['currency']) ? $input['currency'] : 'ron';

try {
    // Creează Payment Intent
    $paymentIntent = \Stripe\PaymentIntent::create([
        'amount' => intval($amount * 100), // Convert to cents
        'currency' => strtolower($currency),
        'payment_method_types' => ['card'],
        'description' => 'Plata de test - ' . date('Y-m-d H:i:s'),
    ]);

    // Returnează client_secret
    echo json_encode([
        'success' => true,
        'clientSecret' => $paymentIntent->client_secret,
        'paymentIntentId' => $paymentIntent->id,
    ]);

} catch (\Stripe\Exception\ApiErrorException $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Eroare server: ' . $e->getMessage(),
    ]);
}
?>

