<?php
/**
 * Stripe Test Script
 * Test script pentru integrarea cu Stripe API
 */

// Încarcă Stripe SDK (funcționează cu sau fără Composer)
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
} elseif (file_exists(__DIR__ . '/lib/init.php')) {
    require_once __DIR__ . '/lib/init.php';
} else {
    die("❌ Eroare: Nu s-a găsit Stripe SDK!\n\n" .
        "Instalează Stripe SDK:\n" .
        "1. Download: https://github.com/stripe/stripe-php/releases\n" .
        "2. Extrage folderul 'lib' din ZIP\n" .
        "3. Upload folderul 'lib' în același director cu acest script\n");
}

// Cheile API Stripe
$secretKey = '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';
$publishableKey = 'pk_live_51SGafAAqKXcemKaAOiXZdcPIeG1N3riC3DIkczqrH2gOHWxsxa8e8aLABtoTRy2ifqTvFt2Nw9ZAJDNdx6SiEmL00Q92ZQAOH';

// Inițializare Stripe cu secret key
\Stripe\Stripe::setApiKey($secretKey);

echo "=== Stripe Test Script ===\n\n";

try {
    // Test 1: Verificare conexiune - obținere account info
    echo "1. Testare conexiune Stripe...\n";
    $account = \Stripe\Account::retrieve();
    echo "   ✓ Conectat cu succes!\n";
    echo "   Account ID: " . $account->id . "\n";
    echo "   Email: " . ($account->email ?? 'N/A') . "\n\n";

    // Test 2: Listare produse
    echo "2. Listare produse...\n";
    $products = \Stripe\Product::all(['limit' => 5]);
    echo "   Găsite " . count($products->data) . " produse\n";
    foreach ($products->data as $product) {
        echo "   - " . $product->name . " (ID: " . $product->id . ")\n";
    }
    echo "\n";

    // Test 3: Listare prețuri
    echo "3. Listare prețuri...\n";
    $prices = \Stripe\Price::all(['limit' => 5]);
    echo "   Găsite " . count($prices->data) . " prețuri\n";
    foreach ($prices->data as $price) {
        $amount = $price->unit_amount / 100; // Convert from cents
        $currency = strtoupper($price->currency);
        echo "   - " . $amount . " " . $currency . " (ID: " . $price->id . ")\n";
    }
    echo "\n";

    // Test 4: Creare Payment Intent (exemplu)
    echo "4. Creare Payment Intent de test...\n";
    try {
        $paymentIntent = \Stripe\PaymentIntent::create([
            'amount' => 2000, // 20.00 RON sau USD
            'currency' => 'ron',
            'payment_method_types' => ['card'],
            'description' => 'Test payment intent',
        ]);
        echo "   ✓ Payment Intent creat cu succes!\n";
        echo "   Payment Intent ID: " . $paymentIntent->id . "\n";
        echo "   Status: " . $paymentIntent->status . "\n";
        echo "   Amount: " . ($paymentIntent->amount / 100) . " " . strtoupper($paymentIntent->currency) . "\n\n";
    } catch (\Stripe\Exception\ApiErrorException $e) {
        echo "   ⚠ Eroare la crearea Payment Intent: " . $e->getMessage() . "\n\n";
    }

    // Test 5: Listare clienți
    echo "5. Listare clienți...\n";
    $customers = \Stripe\Customer::all(['limit' => 5]);
    echo "   Găsiți " . count($customers->data) . " clienți\n";
    foreach ($customers->data as $customer) {
        echo "   - " . ($customer->email ?? 'N/A') . " (ID: " . $customer->id . ")\n";
    }
    echo "\n";

    // Test 6: Informații despre chei
    echo "6. Informații despre chei API:\n";
    echo "   Secret Key: " . substr($secretKey, 0, 20) . "...\n";
    echo "   Publishable Key: " . substr($publishableKey, 0, 20) . "...\n";
    echo "   Mod: LIVE (chei de producție)\n\n";

    echo "=== Test finalizat cu succes! ===\n";

} catch (\Stripe\Exception\AuthenticationException $e) {
    echo "❌ Eroare de autentificare: " . $e->getMessage() . "\n";
    echo "Verifică dacă cheile API sunt corecte.\n";
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo "❌ Eroare API Stripe: " . $e->getMessage() . "\n";
    echo "Tip eroare: " . $e->getStripeCode() . "\n";
} catch (Exception $e) {
    echo "❌ Eroare generală: " . $e->getMessage() . "\n";
}
?>

